import java.awt.*;
import javax.swing.*;
import java.text.*;

// Uses older 1.00 implementation of gaussian method.
// Same algorithm and basic design

public class GElim extends JFrame {
    
	/** Creates new form GElim */
	public GElim() {
		initComponents();
		initMatrixDisplay(3,4);
		model = new Model();
	}
    
	public void initMatrixDisplay(int i, int j){
		matrixDisplay = new MatrixDisplay(i,j);
		getContentPane().add(matrixDisplay, BorderLayout.CENTER);
		pack();
	}
    
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	private void initComponents() {
		bottomPanel = new javax.swing.JPanel();
		outputPanel = new javax.swing.JPanel();
		ouputLabel = new javax.swing.JLabel();
		controlPanel = new javax.swing.JPanel();
		pivotButton = new javax.swing.JButton();
		backSolveButton = new javax.swing.JButton();
		divideButton = new javax.swing.JButton();
		solveButton = new javax.swing.JButton();
		swapRow = new javax.swing.JPanel();
		swapLabel1 = new javax.swing.JLabel();
		swapText1 = new javax.swing.JTextField();
		swapLabel2 = new javax.swing.JLabel();
		swapText2 = new javax.swing.JTextField();
		swapButton = new javax.swing.JButton();
		rowOperationPanel = new javax.swing.JPanel();
		rowOperationLabel1 = new javax.swing.JLabel();
		mult1Text = new javax.swing.JTextField();
		jLabel2 = new javax.swing.JLabel();
		rowOperation1Text = new javax.swing.JTextField();
		plusLabel = new javax.swing.JLabel();
		mult2Text = new javax.swing.JTextField();
		jLabel4 = new javax.swing.JLabel();
		rowOperation2Text = new javax.swing.JTextField();
		rowOperationButton = new javax.swing.JButton();
		topPanel = new javax.swing.JPanel();
		buttonHolder = new javax.swing.JPanel();
		numEquLabel = new javax.swing.JLabel();
		numEquText = new javax.swing.JTextField();
		setupButton = new javax.swing.JButton();
		editPanel = new javax.swing.JPanel();
		undoButton = new javax.swing.JButton();
		saveButton = new javax.swing.JButton();
		loadButton = new javax.swing.JButton();
		demoButton = new javax.swing.JButton();
		quitButton = new javax.swing.JButton();
        
		setTitle("Systems of Linear Equations");
		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent evt) {
				exitForm(evt);
			}
		});
        
		bottomPanel.setLayout(new java.awt.GridLayout(4, 0));
        
		outputPanel.setBorder(new javax.swing.border.EtchedBorder(null, java.awt.Color.black));
		outputPanel.setBackground(java.awt.Color.white);
		outputPanel.add(ouputLabel);
        
		bottomPanel.add(outputPanel);
        
		pivotButton.setToolTipText("Perform a forward solve by reducing to 0 the cells below the selected cell");
		pivotButton.setText("Pivot on Selection");
		pivotButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				pivotButtonActionPerformed(evt);
			}
		});
        
		controlPanel.add(pivotButton);
        
		backSolveButton.setToolTipText("Substitue the value of the selected cell in the rows above it.");
		backSolveButton.setText("Back Subst. on Selection");
		backSolveButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				backSolveButtonActionPerformed(evt);
			}
		});
        
		controlPanel.add(backSolveButton);
        
		divideButton.setToolTipText("Divide the entire row by the value of the selected cell");
		divideButton.setText("Divide on Selection");
		divideButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				divideButtonActionPerformed(evt);
			}
		});
        
		controlPanel.add(divideButton);
        
		solveButton.setToolTipText("Reduce the matrix to a \"reduced row echelon form\"");
		solveButton.setText("Solve");
		solveButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				solveButtonActionPerformed(evt);
			}
		});
        
		controlPanel.add(solveButton);
        
		bottomPanel.add(controlPanel);
        
		swapLabel1.setText("Swap Rows:");
		swapRow.add(swapLabel1);
        
		swapText1.setColumns(3);
		swapRow.add(swapText1);
        
		swapLabel2.setText("and");
		swapRow.add(swapLabel2);
        
		swapText2.setColumns(3);
		swapRow.add(swapText2);
        
		swapButton.setToolTipText("Swap the first named row with the second");
		swapButton.setText("Swap");
		swapButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				swapButtonActionPerformed(evt);
			}
		});
        
		swapRow.add(swapButton);
        
		bottomPanel.add(swapRow);
        
		rowOperationLabel1.setText("Row Operation:");
		rowOperationPanel.add(rowOperationLabel1);
        
		mult1Text.setColumns(4);
		rowOperationPanel.add(mult1Text);
        
		jLabel2.setText("x Row");
		rowOperationPanel.add(jLabel2);
        
		rowOperation1Text.setColumns(3);
		rowOperationPanel.add(rowOperation1Text);
        
		plusLabel.setText("+");
		rowOperationPanel.add(plusLabel);
        
		mult2Text.setColumns(4);
		rowOperationPanel.add(mult2Text);
        
		jLabel4.setText("x Row");
		rowOperationPanel.add(jLabel4);
        
		rowOperation2Text.setColumns(3);
		rowOperationPanel.add(rowOperation2Text);
        
		rowOperationButton.setToolTipText("Either multiply a row by a constant or replace the first named row by a combination with the second ");
		rowOperationButton.setText("Commit");
		rowOperationButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				rowOperationButtonActionPerformed(evt);
			}
		});
        
		rowOperationPanel.add(rowOperationButton);
        
		bottomPanel.add(rowOperationPanel);
        
		getContentPane().add(bottomPanel, java.awt.BorderLayout.SOUTH);
        
		topPanel.setLayout(new java.awt.GridLayout(3, 0));
        
		numEquLabel.setText("Number of Variables and Equations");
		buttonHolder.add(numEquLabel);
        
		numEquText.setColumns(3);
		buttonHolder.add(numEquText);
        
		setupButton.setToolTipText("Construct a NxN matrix with N = number of Variables = number of Equations");
		setupButton.setText("Setup");
		setupButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				setupButtonActionPerformed(evt);
			}
		});
        
		buttonHolder.add(setupButton);
        
		topPanel.add(buttonHolder);
        
		undoButton.setToolTipText("Reverse the previous action");
		undoButton.setText("Undo");
		undoButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				undoButtonActionPerformed(evt);
			}
		});
        
		editPanel.add(undoButton);
        
		saveButton.setToolTipText("Save the current matrix.");
		saveButton.setText("Save");
		saveButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				saveButtonActionPerformed(evt);
			}
		});
        
		editPanel.add(saveButton);
        
		loadButton.setToolTipText("Load the saved matrix");
		loadButton.setText("Load");
		loadButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				loadButtonActionPerformed(evt);
			}
		});
        
		editPanel.add(loadButton);
        
		demoButton.setToolTipText("Load a pre-saved matrix");
		demoButton.setText("Demo");
		demoButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				demoButtonActionPerformed(evt);
			}
		});
        
		editPanel.add(demoButton);
        
		quitButton.setToolTipText("Exit the program");
		quitButton.setText("Quit");
		quitButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				quitButtonActionPerformed(evt);
			}
		});
        
		editPanel.add(quitButton);
        
		topPanel.add(editPanel);
        
		getContentPane().add(topPanel, java.awt.BorderLayout.NORTH);
        
		pack();
	}
    
	private void backSolveButtonActionPerformed(java.awt.event.ActionEvent evt) {
		try{
            
			model.setCurrentMatrix(matrixDisplay.getMatrix());
            
			if(model.backSolve_check1(matrixDisplay.getCurrentCol()) ) //selection belongs to b matrix                
				ouputLabel.setText("Cannot substitute on b. You need to select a cell in A");
			else{
                
				if(model.backSolve_check2(matrixDisplay.getCurrentRow(), matrixDisplay.getCurrentCol()))
					// selection is not the only non-zero x in the row
					ouputLabel.setText("Value of x" + matrixDisplay.getCurrentCol()+ " is still unknown. Cannot back substitute.");
				else{
					model.backSolve_selection(matrixDisplay.getCurrentRow(), matrixDisplay.getCurrentCol());
					matrixDisplay.setMatrix(model.getCurrentMatrix());
					ouputLabel.setText("");
				}
			}
			
			model.divide_selection(matrixDisplay.getCurrentRow(), matrixDisplay.getCurrentCol());
			matrixDisplay.setMatrix(model.getCurrentMatrix());
			ouputLabel.setText("");
		}
		catch(IllegalArgumentException e){
			ouputLabel.setText("Cannot back solve on a 0");
		}
	}
    
	private void quitButtonActionPerformed(java.awt.event.ActionEvent evt) {
		System.exit(0);
	}
    
	private void demoButtonActionPerformed(java.awt.event.ActionEvent evt) {
		Matrix demoMatrix = model.getDemoMatrix();
        
		if(demoMatrix != null){
			getContentPane().remove(matrixDisplay);
			matrixDisplay = new MatrixDisplay(demoMatrix.getNumRows(), demoMatrix.getNumCols());
			getContentPane().add(matrixDisplay, BorderLayout.CENTER);
			pack();
			matrixDisplay.setMatrix(demoMatrix);
			ouputLabel.setText("Demo Loaded");
		}
		else{
			ouputLabel.setText("No Demo available");
		}
	}
    
	private void loadButtonActionPerformed(java.awt.event.ActionEvent evt) {
		Matrix savedMatrix = model.getSavedMatrix();
        
		if(savedMatrix != null){
			getContentPane().remove(matrixDisplay);
			matrixDisplay = new MatrixDisplay(savedMatrix.getNumRows(), savedMatrix.getNumCols());
			getContentPane().add(matrixDisplay, BorderLayout.CENTER);
			pack();
			matrixDisplay.setMatrix(savedMatrix);
			ouputLabel.setText("Matrix Loaded");
		}
		else{
			ouputLabel.setText("Nothing Saved");
		}
	}
    
	private void saveButtonActionPerformed(java.awt.event.ActionEvent evt) {
		model.setSavedMatrix(matrixDisplay.getMatrix());
		ouputLabel.setText("Matrix Saved");
	}
    
	private void undoButtonActionPerformed(java.awt.event.ActionEvent evt) {
		Matrix previousMatrix = model.getPreviousMatrix();
		if(previousMatrix != null){
			matrixDisplay.setMatrix(previousMatrix);
			ouputLabel.setText("");
		}
		else{
			ouputLabel.setText("Nothing to Undo");
		}
	}
    
	private void rowOperationButtonActionPerformed(java.awt.event.ActionEvent evt) {
		int row1 = 1,row2 =1;
		double mult1=1, mult2=0;
		boolean flag = true;
        
		try{
			row1 = Integer.parseInt(rowOperation1Text.getText());
		}
		catch(NumberFormatException e){flag = false; ouputLabel.setText("Row Undefined");        }
        
		try{
			if((rowOperation2Text.getText()).equals(""))
				row2=1;
			else
				row2 = Integer.parseInt(rowOperation2Text.getText());
            
		}
		catch(NumberFormatException e){ouputLabel.setText("Invalid input"); flag = false;}
        
		try{
			if((mult1Text.getText()).equals(""))
				mult1=1;
			else
				mult1 = Double.parseDouble(mult1Text.getText());
		}
		catch(NumberFormatException e){ flag = false; ouputLabel.setText("Invalid input");}
        
		try{
			if((mult2Text.getText()).equals(""))
				mult2=0;
			else
				mult2 = Double.parseDouble(mult2Text.getText());
            
		}
		catch(NumberFormatException e){ flag = false; ouputLabel.setText("Invalid input");}
        
		if(flag){
			try{
				model.setCurrentMatrix(matrixDisplay.getMatrix());
				model.row_operation(row1,mult1,row2,mult2);
				matrixDisplay.setMatrix(model.getCurrentMatrix());
				ouputLabel.setText("");
			}
			catch(IllegalArgumentException e){
				ouputLabel.setText("Invalid row numbers");
			}
		}
	}
    
	private void swapButtonActionPerformed(java.awt.event.ActionEvent evt) {
		try{
			int row1 = Integer.parseInt(swapText1.getText());
			int row2 = Integer.parseInt(swapText2.getText());
			if(row1 <0 || row2<0)
				ouputLabel.setText("Please enter integers bigger than 0");
			else{
				model.setCurrentMatrix(matrixDisplay.getMatrix());
				model.swap_rows(row1, row2);
				matrixDisplay.setMatrix(model.getCurrentMatrix());
				ouputLabel.setText("");
			}
		}
		catch(IllegalArgumentException e){
			ouputLabel.setText("Invalid row numbers");
		}
	}
    
	private void divideButtonActionPerformed(java.awt.event.ActionEvent evt) {
		try{
			model.setCurrentMatrix(matrixDisplay.getMatrix());
			model.divide_selection(matrixDisplay.getCurrentRow(), matrixDisplay.getCurrentCol());
			matrixDisplay.setMatrix(model.getCurrentMatrix());
			ouputLabel.setText("");
		}
		catch(IllegalArgumentException e){
			ouputLabel.setText("Cannot divide by 0");
		}
	}
    
	private void pivotButtonActionPerformed(java.awt.event.ActionEvent evt) {
		try{
			model.setCurrentMatrix(matrixDisplay.getMatrix());
			model.pivot_selection(matrixDisplay.getCurrentRow(), matrixDisplay.getCurrentCol());
			matrixDisplay.setMatrix(model.getCurrentMatrix());
			ouputLabel.setText("");
		}
		catch(IllegalArgumentException e){
			ouputLabel.setText("Cannot pivot on a 0");
		}
	}
    
	private void solveButtonActionPerformed(java.awt.event.ActionEvent evt) {
		try{
			model.setCurrentMatrix(matrixDisplay.getMatrix());
			matrixDisplay.setMatrix(model.solve());
			ouputLabel.setText("Matrix Solved");
		}
		catch(NumberFormatException e){
			ouputLabel.setText("Matrix Solved");
		}
	}
    
    
	private void setupButtonActionPerformed(java.awt.event.ActionEvent evt) {
		try{
			int numEqu = Integer.parseInt(numEquText.getText());
			int numUnk = numEqu+1;
			if(numEqu <1 || numUnk<1)
				ouputLabel.setText("Please enter integer bigger than 1");
			else{
				getContentPane().remove(matrixDisplay);
				matrixDisplay = new MatrixDisplay(numEqu, numUnk);
				getContentPane().add(matrixDisplay, BorderLayout.CENTER);
				pack();
				ouputLabel.setText("");
				model.reset(numEqu,numUnk);
			}
		}
		catch(NumberFormatException e){
			ouputLabel.setText("Please enter integers bigger than 1");
		}
        
	}
    
	private void exitForm(java.awt.event.WindowEvent evt) {
		System.exit(0);
	}
    
	public static void main(String args[]) {
		new GElim().setVisible(true);
	}
    
	// Variables declaration - do not modify
	private javax.swing.JPanel bottomPanel;
	private javax.swing.JPanel outputPanel;
	private javax.swing.JLabel ouputLabel;
	private javax.swing.JPanel controlPanel;
	private javax.swing.JButton pivotButton;
	private javax.swing.JButton backSolveButton;
	private javax.swing.JButton divideButton;
	private javax.swing.JButton solveButton;
	private javax.swing.JPanel swapRow;
	private javax.swing.JLabel swapLabel1;
	private javax.swing.JTextField swapText1;
	private javax.swing.JLabel swapLabel2;
	private javax.swing.JTextField swapText2;
	private javax.swing.JButton swapButton;
	private javax.swing.JPanel rowOperationPanel;
	private javax.swing.JLabel rowOperationLabel1;
	private javax.swing.JTextField mult1Text;
	private javax.swing.JLabel jLabel2;
	private javax.swing.JTextField rowOperation1Text;
	private javax.swing.JLabel plusLabel;
	private javax.swing.JTextField mult2Text;
	private javax.swing.JLabel jLabel4;
	private javax.swing.JTextField rowOperation2Text;
	private javax.swing.JButton rowOperationButton;
	private javax.swing.JPanel topPanel;
	private javax.swing.JPanel buttonHolder;
	private javax.swing.JLabel numEquLabel;
	private javax.swing.JTextField numEquText;
	private javax.swing.JButton setupButton;
	private javax.swing.JPanel editPanel;
	private javax.swing.JButton undoButton;
	private javax.swing.JButton saveButton;
	private javax.swing.JButton loadButton;
	private javax.swing.JButton demoButton;
	private javax.swing.JButton quitButton;
	// End of variables declaration
	private MatrixDisplay matrixDisplay;
	private int currentRow;
	private int currentCol;
	Model model;
}

class Gauss{
    
	public static void gaussian(Matrix a, Matrix b,  Matrix x) {
		int i, j, n;
		n= a.getNumRows();               // Number of unknowns
		Matrix q= new Matrix(n, n+1);
		for (i=0; i < n; i++) {
			for (j=0; j < n; j++)        // Form q matrix
				// q(i,j)= a(i,j)
				q.setElement(i, j, a.getElement(i, j));
			// q(i,n)= b(i,0)
			q.setElement(i, n, b.getElement(i, 0));
		}
		forward_solve(q);          // Do Gaussian elimination
		back_solve(q);             // Perform back substitution
        
		for (i=0; i<n; i++)
			// x(i,0)= q(i,n)
			x.setElement(i, 0, q.getElement(i, n));
	}
    
	public static void gaussian(Matrix a,  Matrix x) {
		int i, j, n, c;
		n= a.getNumRows();               // Number of unknowns
		c= a.getNumCols();
        
		Matrix q= new Matrix(n, c);
		for (i=0; i < n; i++) {
			for (j=0; j < c; j++)        // Form q matrix
				// q(i,j)= a(i,j)
				q.setElement(i, j, a.getElement(i, j));
		}
        
		forward_solve(q);          // Do Gaussian elimination
		back_solve(q);             // Perform back substitution
        
		for (i=0; i<n; i++)
			// x(i,0)= q(i,n)
			x.setElement(i, 0, q.getElement(i, n));
	}
    
	private static void forward_solve(Matrix q) {
		int i, j, k, maxr, n;
		double t, pivot;
		n= q.getNumRows();
        
		for (i=0; i < n; i++) {  // Find row w/max element in this
			maxr= i;		// column, at or below diagonal
			for (j= i+1; j < n; j++)
				if (Math.abs(q.getElement(j,i)) >Math.abs(q.getElement(maxr,i)))
					maxr= j;
			if (maxr != i)		// If row not current row, swap
				for (k=i; k <= n; k++)
				{ t= q.getElement(i,k);        // t= q(i,k)
				  // q(i,k)= q(maxr, k)
				  q.setElement(i,k, q.getElement(maxr, k));
				  q.setElement(maxr, k, t);    // q(maxr, k)= t
				}
			for (j= i+1; j <n; j++)     // Calculate pivot ratio
			{ pivot= q.getElement(j,i)/q.getElement(i,i);
			  for (k= n; k >=i; k--)
				  q.setElement(j, k, q.getElement(j,k)-
				  q.getElement(i,k)*pivot);
			  // q(j,k) -= q(i,k)*pivot; Update row j below diag
			}
		}
	}
    
	private static void back_solve(Matrix q) {
		int j, k, n;
		double t; 				// t- temporary
		n= q.getNumRows();
        
		for (j=n-1; j >=0; j--) 		// Start at last row
		{
			t= 0.0;
			for (k= j+1; k < n; k++)    // t += q(j,k)* q(k,n)
				t += q.getElement(j,k)* q.getElement(k,n);
			q.setElement(j, n,
			(q.getElement(j, n) -t)/q.getElement(j,j));
			// q(j, n)= (q(j, n) -t)/q(j,j);
		}
	}
    
	public static void divide_selection(Matrix q, int pivotRow, int pivotCol){
		int n;
		n = q.getNumCols();
		double denom = q.getElement(pivotRow,pivotCol);
        
		for(int j=0; j<n; j++){
			double ratio = q.getElement(pivotRow,j)/denom;
			q.setElement(pivotRow, j, ratio);
            
		}
        
	}
    
	public static void pivot_selection(Matrix q, int pivotRow, int pivotCol){
        
		//divide_selection(q, pivotRow, pivotCol);       //Reduce selected row
        
		for(int i=pivotRow+1; i<q.getNumRows(); i++){
			double pivot = -q.getElement(i,pivotCol)/q.getElement(pivotRow,pivotCol);
			for(int j=0; j<q.getNumCols(); j++){
				double num = q.getElement(i,j) + q.getElement(pivotRow,j)*pivot;
				q.setElement(i, j, num);
			}
		}
	}
    
	public static void backSolve_selection(Matrix q, int backSolveRow, int backSolveCol){
        
		//divide_selection(q, pivotRow, pivotCol);       //Reduce selected row
        
		for(int i=backSolveRow-1; i>=0; i--){
			double pivot = -q.getElement(i,backSolveCol)/q.getElement(backSolveRow,backSolveCol);
			for(int j=0; j<q.getNumCols(); j++){
				double num = q.getElement(i,j) + q.getElement(backSolveRow,j)*pivot;
				q.setElement(i, j, num);
			}
		}
	}
}

class MatrixDisplay extends JPanel {
    
	private int rows;
	private int cols;
    
	private Matrix matrix;
    
	private JTextField[][] cell;
	private JPanel rowPanel[];
    
	private int currentRow;         //keeps track of the cell which has the focus
	private int currentCol;
    
	public MatrixDisplay(int rows, int cols) {
		//add a row and columns for titles
		this.rows = rows+1;
		this.cols = cols+1;
		matrix = new Matrix(rows,cols);
		initComponents();
	}
    
    
	private void initComponents() {
        
		int numPanels =rows+1;
        
		setLayout(new java.awt.GridLayout(numPanels, 0));
		rowPanel = new JPanel[numPanels];
		for(int i=0; i<numPanels; i++){
			rowPanel[i] = new JPanel();
			rowPanel[i].setLayout(new FlowLayout(FlowLayout.LEFT));
			add(rowPanel[i]);
		}
        
		cell = new JTextField[rows][cols];
        
		//Set up labels in the first row
		for(int i=0; i<rows; i++)
			for(int j=0; j <cols; j++){
				cell[i][j] = new JTextField();
				cell[i][j].addFocusListener(new java.awt.event.FocusAdapter() {
					public void focusGained(java.awt.event.FocusEvent evt) {
						cellFocusGained(evt);}
				});
				cell[i][j].setColumns(5);
				cell[i][j].setHorizontalAlignment(JTextField.CENTER);
				rowPanel[i].add(cell[i][j]);
                
				if(i==0 || j==0)
					cell[i][j].setEditable(false);
				else
					cell[i][j].setEditable(true);
                
				//Labels on row 0
				if(i == 0 && j!=0){
					cell[0][j].setText("x" + Integer.toString(j-1) );
					if(j == cols-1)
						cell[0][j].setText("b");
				}
                
                
				//Labels on column 0
				if(i!=0 && j==0)
					cell[i][j].setText(Integer.toString(i-1));
			}
	}
    
	public Matrix getMatrix() throws  NumberFormatException{
        
		for(int i=1; i<rows; i++)
			for(int j=1; j<cols; j++){
				double num;
				if((cell[i][j].getText()).equals(""))
					num = 0;
				else{
					try{
						num = Double.parseDouble(cell[i][j].getText());
					}
					catch(NumberFormatException e){
						throw new NumberFormatException();
					}
                    
				}
				matrix.setElement(i-1,j-1,num);
			}
		return matrix;
	}
    
	public void setMatrix(Matrix m) {
		NumberFormat nf = NumberFormat.getInstance();
		nf.setMaximumFractionDigits(4);
		for(int i=0; i<m.getNumRows(); i++)
			for(int j=0; j<m.getNumCols(); j++){
				String num = nf.format(m.getElement(i,j));
				cell[i+1][j+1].setText(num);
			}
	}
    
	public int getCurrentRow(){
		if(currentRow !=0)
			return currentRow -1;
		else
			return 0;
	}
    
	public int getCurrentCol(){
		if(currentCol !=0)
			return currentCol -1;
		else
			return 0;
	} 
    
	public void cellFocusGained(java.awt.event.FocusEvent evt){
		  for(int i =1; i<rows; i++)
			for(int j =1; j<cols; j++)
				if(cell[i][j].hasFocus()){
					currentRow =i;
					currentCol =j;
					break;
				}    
	}
}

class Model{
    
	private Matrix savedMatrix;
	private Matrix currentMatrix;
	private Matrix demoMatrix;
	private Matrix previousMatrix;
    
	public Matrix getCurrentMatrix(){
		return currentMatrix;
	}
    
	public void setCurrentMatrix(Matrix m){        
		currentMatrix =m;
        
		int rows = currentMatrix.getNumRows();
		int cols = currentMatrix.getNumCols();
		previousMatrix = new Matrix(rows, cols);
        
		for(int i=0; i<rows; i++)
			for(int j=0; j<cols; j++)
				previousMatrix.setElement(i,j, currentMatrix.getElement(i,j));        
	}
    
	public void setSavedMatrix(Matrix m){
		int rows;
		int cols;
		rows = m.getNumRows();
		cols = m.getNumCols();
		savedMatrix = new Matrix(rows,cols);
		for(int i=0; i<rows; i++)
			for(int j=0; j<cols; j++)
				savedMatrix.setElement(i,j, m.getElement(i,j));        
	}
    
	public Matrix getSavedMatrix(){       
		return savedMatrix;        
	}   
    
	public Matrix getPreviousMatrix(){
		return previousMatrix;
	}
    
	public Matrix getDemoMatrix(){
		setupDemo();
		return demoMatrix;
	} 
    
	public void reset(int rows, int cols){     
		currentMatrix = new Matrix(rows, cols);
	}
    
	public Matrix solve() throws NumberFormatException{
		int rows = currentMatrix.getNumRows();
		int cols = currentMatrix.getNumCols();
		if(cols <=1)
			throw new NumberFormatException();
		else{
			Matrix solutionMatrix = new Matrix(rows,1);
			Gauss.gaussian(currentMatrix, solutionMatrix);
			currentMatrix = new Matrix(rows, cols);
			currentMatrix.setIdentity();
			for(int i=0;i<rows; i++)
				currentMatrix.setElement(i,cols-1, solutionMatrix.getElement(i,0));
		}
		return currentMatrix;
	}
    
	public void setupDemo(){
		demoMatrix = new Matrix(3,4);
		demoMatrix.setElement(0,0,3);
		demoMatrix.setElement(0,1,1);
		demoMatrix.setElement(0,2,-2);
		demoMatrix.setElement(0,3,5);
		demoMatrix.setElement(1,0,2);
		demoMatrix.setElement(1,1,4);
		demoMatrix.setElement(1,2,3);
		demoMatrix.setElement(1,3,35);
		demoMatrix.setElement(2,0,1);
		demoMatrix.setElement(2,1,-3);
		demoMatrix.setElement(2,2,0);
		demoMatrix.setElement(2,3,-5);
	}
    
	public void divide_selection(int i, int j) throws IllegalArgumentException {
		if(Math.abs(currentMatrix.getElement(i,j)) <= 0.0000001)
			throw new IllegalArgumentException();
		else
			Gauss.divide_selection(currentMatrix,i,j);       
	}
    
	public void pivot_selection(int i, int j) throws IllegalArgumentException {
		if(Math.abs(currentMatrix.getElement(i,j)) <= 0.0000001)
			throw new IllegalArgumentException();
		else
			Gauss.pivot_selection(currentMatrix,i,j);
	}
    
	public void backSolve_selection(int i, int j) throws IllegalArgumentException {
		if(Math.abs(currentMatrix.getElement(i,j)) <= 0.0000001)
			throw new IllegalArgumentException();
		else
			Gauss.backSolve_selection(currentMatrix,i,j);
	}
	//Checks whether selection is the only non-zero x in the row
	public boolean backSolve_check2(int currentRow, int currentCol){
		boolean flag = false;
		for(int j=0; j<currentMatrix.getNumCols()-1; j++)
			if(Math.abs(currentMatrix.getElement(currentRow,j)) >= 0.0000001 && j!= currentCol)
				//selection is not the only non-zero x in the row
				flag = true;
		if(Math.abs(currentMatrix.getElement(currentRow, currentCol)) <= 0.0000001)
			//In case selection is 0, then we don't know if selection is know or not.
			//backSolve_selection(i,j) will handle it. return true.
			flag = false;        
        
		return flag;       
	}
    
	//Checks whether selection is in the b matrix
	public boolean backSolve_check1(int currentCol){        
		if (currentCol == (currentMatrix.getNumCols() -1))
			return true;
		else
			return false;
	}
    
	public void swap_rows(int row1, int row2) throws IllegalArgumentException{
		double tempValue;
		if(row1>= currentMatrix.getNumRows() || row2>= currentMatrix.getNumRows())
			throw new IllegalArgumentException();
		else{
			for(int j=0; j<currentMatrix.getNumCols(); j++){
				tempValue = currentMatrix.getElement(row1, j);
				currentMatrix.setElement(row1, j, currentMatrix.getElement(row2,j));
				currentMatrix.setElement(row2, j, tempValue);
			}
		}
	}
    
	public void row_operation(int row1, double mult1, int row2, double mult2) throws IllegalArgumentException{
        
		if(row1>= currentMatrix.getNumRows() || row2>= currentMatrix.getNumRows()
				|| row1 < 0 || row2< 0)
			throw new IllegalArgumentException();
		else{
			for(int j=0; j< currentMatrix.getNumCols(); j++){
				double addValue = currentMatrix.getElement(row2,j)*mult2;
				double newValue = currentMatrix.getElement(row1,j) * mult1 + addValue;
				currentMatrix.setElement(row1,j, newValue);
			}
		}
        
	}
}
